/*
 * Decompiled with CFR 0.152.
 */
package xyz.zenuxs.libs.jackson.databind.util;

import java.io.Serializable;
import xyz.zenuxs.libs.jackson.databind.AnnotationIntrospector;
import xyz.zenuxs.libs.jackson.databind.BeanDescription;
import xyz.zenuxs.libs.jackson.databind.JavaType;
import xyz.zenuxs.libs.jackson.databind.PropertyName;
import xyz.zenuxs.libs.jackson.databind.cfg.MapperConfig;
import xyz.zenuxs.libs.jackson.databind.introspect.AnnotatedClass;
import xyz.zenuxs.libs.jackson.databind.type.ClassKey;
import xyz.zenuxs.libs.jackson.databind.util.LRUMap;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public PropertyName findRootName(Class<?> rootType, MapperConfig<?> config) {
        AnnotatedClass ac;
        ClassKey key = new ClassKey(rootType);
        PropertyName name = this._rootNames.get(key);
        if (name != null) {
            return name;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        name = intr.findRootName(ac = beanDesc.getClassInfo());
        if (name == null || !name.hasSimpleName()) {
            name = PropertyName.construct(rootType.getSimpleName());
        }
        this._rootNames.put(key, name);
        return name;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

