/*
 * Decompiled with CFR 0.152.
 */
package xyz.zenuxs.libs.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import xyz.zenuxs.libs.jackson.core.JsonGenerator;
import xyz.zenuxs.libs.jackson.core.JsonToken;
import xyz.zenuxs.libs.jackson.core.type.WritableTypeId;
import xyz.zenuxs.libs.jackson.databind.JavaType;
import xyz.zenuxs.libs.jackson.databind.JsonMappingException;
import xyz.zenuxs.libs.jackson.databind.JsonNode;
import xyz.zenuxs.libs.jackson.databind.SerializerProvider;
import xyz.zenuxs.libs.jackson.databind.annotation.JacksonStdImpl;
import xyz.zenuxs.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import xyz.zenuxs.libs.jackson.databind.jsontype.TypeSerializer;
import xyz.zenuxs.libs.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ToEmptyObjectSerializer
extends StdSerializer<Object> {
    protected ToEmptyObjectSerializer(Class<?> raw) {
        super(raw, false);
    }

    public ToEmptyObjectSerializer(JavaType type) {
        super(type);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectObjectFormat(typeHint);
    }
}

