/*
 * Decompiled with CFR 0.152.
 */
package xyz.zenuxs.libs.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import xyz.zenuxs.libs.jackson.core.JsonGenerator;
import xyz.zenuxs.libs.jackson.core.JsonToken;
import xyz.zenuxs.libs.jackson.core.type.WritableTypeId;
import xyz.zenuxs.libs.jackson.databind.JavaType;
import xyz.zenuxs.libs.jackson.databind.JsonMappingException;
import xyz.zenuxs.libs.jackson.databind.JsonNode;
import xyz.zenuxs.libs.jackson.databind.SerializerProvider;
import xyz.zenuxs.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import xyz.zenuxs.libs.jackson.databind.jsontype.TypeSerializer;
import xyz.zenuxs.libs.jackson.databind.ser.std.StdSerializer;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

