/*
 * Decompiled with CFR 0.152.
 */
package xyz.zenuxs.libs.jackson.databind.ext;

import java.io.IOException;
import java.nio.file.Path;
import xyz.zenuxs.libs.jackson.core.JsonGenerator;
import xyz.zenuxs.libs.jackson.core.JsonToken;
import xyz.zenuxs.libs.jackson.core.type.WritableTypeId;
import xyz.zenuxs.libs.jackson.databind.SerializerProvider;
import xyz.zenuxs.libs.jackson.databind.jsontype.TypeSerializer;
import xyz.zenuxs.libs.jackson.databind.ser.std.StdScalarSerializer;

public class NioPathSerializer
extends StdScalarSerializer<Path> {
    private static final long serialVersionUID = 1L;

    public NioPathSerializer() {
        super(Path.class);
    }

    @Override
    public void serialize(Path value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(value.toUri().toString());
    }

    @Override
    public void serializeWithType(Path value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, Path.class, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }
}

