/*
 * Decompiled with CFR 0.152.
 */
package xyz.zenuxs.libs.jackson.databind.deser.std;

import java.io.IOException;
import xyz.zenuxs.libs.jackson.core.JsonParser;
import xyz.zenuxs.libs.jackson.databind.DeserializationConfig;
import xyz.zenuxs.libs.jackson.databind.DeserializationContext;
import xyz.zenuxs.libs.jackson.databind.JavaType;
import xyz.zenuxs.libs.jackson.databind.deser.std.StdDeserializer;
import xyz.zenuxs.libs.jackson.databind.jsontype.TypeDeserializer;
import xyz.zenuxs.libs.jackson.databind.type.LogicalType;
import xyz.zenuxs.libs.jackson.databind.util.AccessPattern;

public abstract class StdScalarDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;

    protected StdScalarDeserializer(Class<?> vc) {
        super(vc);
    }

    protected StdScalarDeserializer(JavaType valueType) {
        super(valueType);
    }

    protected StdScalarDeserializer(StdScalarDeserializer<?> src) {
        super(src);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.ALWAYS_NULL;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromScalar(p, ctxt);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws IOException {
        ctxt.handleBadMerge(this);
        return this.deserialize(p, ctxt);
    }
}

