/*
 * Decompiled with CFR 0.152.
 */
package xyz.zenuxs.AdvanceLogin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.zenuxs.libs.jackson.core.type.TypeReference;
import xyz.zenuxs.libs.jackson.databind.ObjectMapper;
import xyz.zenuxs.libs.okhttp3.MediaType;
import xyz.zenuxs.libs.okhttp3.OkHttpClient;
import xyz.zenuxs.libs.okhttp3.Request;
import xyz.zenuxs.libs.okhttp3.RequestBody;
import xyz.zenuxs.libs.okhttp3.Response;

public class AdvanceLogin
extends JavaPlugin
implements Listener,
TabCompleter {
    private final Map<UUID, PlayerAuthData> playerData = new ConcurrentHashMap<UUID, PlayerAuthData>();
    private final Map<UUID, Integer> loginAttempts = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Location> originalJoinLocations = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, String> requiredAuthType = new ConcurrentHashMap<UUID, String>();
    private final Map<String, Set<UUID>> ipToPlayers = new ConcurrentHashMap<String, Set<UUID>>();
    private final Set<UUID> processingPlayers = new HashSet<UUID>();
    private final Set<UUID> legacyPlayers = new HashSet<UUID>();
    private final Map<UUID, Boolean> pendingTeleports = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, String> playerSessions = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, String> playerEmails = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, String> otpRequests = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, String> otpEmails = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Long> otpExpiry = new ConcurrentHashMap<UUID, Long>();
    private final Map<String, Boolean> premiumCache = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Long> premiumCacheExpiry = new ConcurrentHashMap<String, Long>();
    private final Map<UUID, BossBar> playerBossBars = new ConcurrentHashMap<UUID, BossBar>();
    private FileConfiguration config;
    private String serverKey;
    private OkHttpClient httpClient;
    private ObjectMapper objectMapper;
    private boolean pluginEnabled = false;
    private static final String API_URL = "https://plugins.zenuxs.in";
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final long OTP_EXPIRY_TIME = 600000L;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.httpClient = new OkHttpClient.Builder().connectTimeout(this.config.getInt("timeout", 10000), TimeUnit.MILLISECONDS).readTimeout(15000L, TimeUnit.MILLISECONDS).build();
        this.objectMapper = new ObjectMapper();
        this.initializeServerKey();
        this.validatePlugin();
        if (this.pluginEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::cleanupSessions, 1200L, 1200L);
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::validatePlugin, 6000L, 6000L);
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::cleanupOTPs, 600L, 600L);
        }
        this.identifyLegacyPlayers();
        this.displayStartupMessage();
        this.getCommand("auth").setTabCompleter((TabCompleter)this);
    }

    private void initializeServerKey() {
        File keyFile = new File(this.getDataFolder(), "key.txt");
        if (keyFile.exists()) {
            try {
                this.serverKey = new String(Files.readAllBytes(keyFile.toPath())).trim();
                this.getLogger().info("Loaded server key from key.txt");
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to read key.txt, generating new key");
                this.generateAndSaveServerKey(keyFile);
            }
        } else {
            this.generateAndSaveServerKey(keyFile);
        }
        if (this.serverKey == null || this.serverKey.isEmpty()) {
            this.serverKey = UUID.randomUUID().toString();
            this.getLogger().warning("Using fallback server key");
        }
    }

    private void generateAndSaveServerKey(File keyFile) {
        try {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            this.serverKey = UUID.randomUUID().toString();
            try (FileWriter writer = new FileWriter(keyFile);){
                writer.write(this.serverKey);
            }
            this.getLogger().info("Generated new server key and saved to key.txt");
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to generate/save server key: " + e.getMessage());
            this.serverKey = UUID.randomUUID().toString();
        }
    }

    private void validatePlugin() {
        new BukkitRunnable(){

            public void run() {
                try {
                    Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/pluginStatus?serverKey=" + AdvanceLogin.this.serverKey).get().build();
                    try (Response response = AdvanceLogin.this.httpClient.newCall(request).execute();){
                        if (response.isSuccessful() && response.body() != null) {
                            Map<String, Object> result = AdvanceLogin.this.objectMapper.readValue(response.body().string(), new TypeReference<Map<String, Object>>(){});
                            final boolean wasEnabled = AdvanceLogin.this.pluginEnabled;
                            AdvanceLogin.this.pluginEnabled = (Boolean)result.getOrDefault("enabled", false);
                            new BukkitRunnable(this){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    if (this.this$1.AdvanceLogin.this.pluginEnabled && !wasEnabled) {
                                        this.this$1.AdvanceLogin.this.getLogger().info("Plugin enabled - Valid license found!");
                                        this.this$1.AdvanceLogin.this.getServer().getPluginManager().registerEvents((Listener)this.this$1.AdvanceLogin.this, (Plugin)this.this$1.AdvanceLogin.this);
                                        this.this$1.AdvanceLogin.this.displayStartupMessage();
                                    } else if (!this.this$1.AdvanceLogin.this.pluginEnabled) {
                                        this.this$1.AdvanceLogin.this.getLogger().severe("Plugin disabled - No valid license found!");
                                        Bukkit.broadcast((String)(String.valueOf(ChatColor.RED) + "[AdvanceAuth] Plugin disabled - Invalid license!"), (String)"authplugin.admin");
                                    }
                                }
                            }.runTask((Plugin)AdvanceLogin.this);
                        } else {
                            AdvanceLogin.this.pluginEnabled = false;
                            AdvanceLogin.this.getLogger().warning("Could not validate plugin license - Server may be down");
                        }
                    }
                }
                catch (Exception e) {
                    AdvanceLogin.this.getLogger().log(Level.WARNING, "Failed to validate plugin license", e);
                    AdvanceLogin.this.pluginEnabled = false;
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void displayStartupMessage() {
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2551           " + String.valueOf(ChatColor.AQUA) + "AdvanceAuth" + String.valueOf(ChatColor.GREEN) + " v1.5.0           \u2551");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2551       " + String.valueOf(ChatColor.WHITE) + "by " + String.valueOf(ChatColor.GOLD) + "Rishabh @ Zenuxs" + String.valueOf(ChatColor.GREEN) + "        \u2551");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2551        " + String.valueOf(ChatColor.YELLOW) + "Zenuxs Plugins " + String.valueOf(ChatColor.GREEN) + "        \u2551");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2551   " + String.valueOf(ChatColor.AQUA) + "Dashboard: " + String.valueOf(ChatColor.WHITE) + "https://plugins.zenuxs.in/advancedAuth/dash" + String.valueOf(ChatColor.GREEN) + " \u2551");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2551   " + String.valueOf(ChatColor.AQUA) + "Discord:   " + String.valueOf(ChatColor.WHITE) + "https://discord.zenuxs.in" + String.valueOf(ChatColor.GREEN) + "          \u2551");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2551                                          \u2551");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2551   " + String.valueOf(ChatColor.WHITE) + "Server Key: " + String.valueOf(ChatColor.AQUA) + this.serverKey.substring(0, 8) + "..." + String.valueOf(ChatColor.GREEN) + "      \u2551");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2551   " + String.valueOf(ChatColor.WHITE) + "Status: " + (this.pluginEnabled ? String.valueOf(ChatColor.GREEN) + "ENABLED" : String.valueOf(ChatColor.RED) + "DISABLED") + String.valueOf(ChatColor.GREEN) + "              \u2551");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u2551   " + String.valueOf(ChatColor.WHITE) + "Premium Auto-Login: " + (this.config.getBoolean("premium.enabled") ? String.valueOf(ChatColor.GREEN) + "ON" : String.valueOf(ChatColor.RED) + "OFF") + String.valueOf(ChatColor.GREEN) + "  \u2551");
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        }, 40L);
    }

    private void identifyLegacyPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.handlePlayerJoin(player);
        }
    }

    private boolean isPremiumAccount(String username) {
        if (!this.config.getBoolean("premium.enabled", true)) {
            return false;
        }
        if (this.config.getBoolean("premium.cache-premium-status", true)) {
            Boolean cached = this.premiumCache.get(username);
            Long expiry = this.premiumCacheExpiry.get(username);
            if (cached != null && expiry != null && expiry > System.currentTimeMillis()) {
                return cached;
            }
        }
        String url = "https://api.mojang.com/users/profiles/minecraft/" + username;
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.httpClient.newCall(request).execute();
        try {
            boolean premium = response.isSuccessful();
            if (this.config.getBoolean("premium.cache-premium-status", true)) {
                long expiry = System.currentTimeMillis() + this.config.getLong("premium.cache-duration", 86400L) * 1000L;
                this.premiumCache.put(username, premium);
                this.premiumCacheExpiry.put(username, expiry);
            }
            boolean bl = premium;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to check premium status for " + username + ": " + e.getMessage());
                return false;
            }
        }
    }

    private void handlePlayerJoin(final Player player) {
        final UUID playerId = player.getUniqueId();
        String sessionToken = this.playerSessions.get(playerId);
        if (sessionToken != null) {
            this.validateSession(player, sessionToken);
            return;
        }
        final boolean premium = this.isPremiumAccount(player.getName());
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("username", player.getName());
                    data.put("serverKey", this.this$0.serverKey);
                    data.put("checkPremium", premium);
                    RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                    Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/checkUser").post(body).build();
                    try (Response response = this.this$0.httpClient.newCall(request).execute();){
                        if (response.isSuccessful() && response.body() != null) {
                            Map<String, Object> result = this.this$0.objectMapper.readValue(response.body().string(), new TypeReference<Map<String, Object>>(){});
                            final boolean exists = (Boolean)result.get("exists");
                            final boolean isPremiumUser = (Boolean)result.getOrDefault("isPremium", false);
                            new BukkitRunnable(this){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    if (exists) {
                                        if (premium && isPremiumUser) {
                                            this.this$1.this$0.autoLoginPlayer(player);
                                        } else {
                                            player.sendMessage(this.this$1.this$0.colorize(this.this$1.this$0.config.getString("messages.welcome-back").replace("%player%", player.getName())));
                                            this.this$1.this$0.requiredAuthType.put(playerId, "login");
                                            this.this$1.this$0.teleportToAuthWorld(player, "login");
                                            this.this$1.this$0.showAuthEffects(player, "login");
                                        }
                                    } else if (premium && this.this$1.this$0.config.getBoolean("premium.auto-register", true)) {
                                        this.this$1.this$0.autoRegisterPremium(player);
                                    } else {
                                        this.this$1.this$0.legacyPlayers.add(playerId);
                                        player.sendMessage(this.this$1.this$0.colorize("&eYou need to register with &b/register <password>&e to continue playing."));
                                        this.this$1.this$0.requiredAuthType.put(playerId, "register");
                                        this.this$1.this$0.teleportToAuthWorld(player, "register");
                                        this.this$1.this$0.showAuthEffects(player, "register");
                                    }
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                }
                catch (Exception e) {
                    this.this$0.getLogger().log(Level.WARNING, "Failed to check user existence for " + player.getName(), e);
                    new BukkitRunnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            player.sendMessage(this.this$1.this$0.colorize("&cPlease use /login <password> or /register <password>"));
                        }
                    }.runTask((Plugin)this.this$0);
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void autoLoginPlayer(Player player) {
        UUID playerId = player.getUniqueId();
        long sessionDuration = this.config.getLong("login.session-duration", 86400L) * 1000L;
        PlayerAuthData authData = new PlayerAuthData(playerId, System.currentTimeMillis() + sessionDuration);
        this.playerData.put(playerId, authData);
        player.sendMessage(this.colorize("&aPremium account detected \u2013 you have been automatically logged in!"));
        this.teleportBackFromAuth(player);
        this.requiredAuthType.remove(playerId);
        this.legacyPlayers.remove(playerId);
        if (this.config.getBoolean("effects.title.enabled", true)) {
            String title = this.config.getString("effects.title.premium-welcome.title", "&aWelcome &e%player%").replace("%player%", player.getName());
            String subtitle = this.config.getString("effects.title.premium-welcome.subtitle", "&7You have been automatically logged in");
            this.sendTitle(player, title, subtitle);
        }
        this.hideBossBar(player);
        player.removePotionEffect(PotionEffectType.BLINDNESS);
        List commands = this.config.getStringList("on-login");
        if (commands != null && !commands.isEmpty()) {
            for (String cmd : commands) {
                String formattedCmd = cmd.replace("%player%", player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)formattedCmd);
            }
        }
    }

    private void autoRegisterPremium(final Player player) {
        final UUID playerId = player.getUniqueId();
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("username", player.getName());
                    data.put("serverKey", this.this$0.serverKey);
                    data.put("ip", this.this$0.getPlayerIP(player));
                    data.put("premium", true);
                    RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                    Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/registerPremium").post(body).build();
                    try (Response response = this.this$0.httpClient.newCall(request).execute();){
                        if (response.isSuccessful()) {
                            new BukkitRunnable(this){
                                final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    player.sendMessage(this.this$1.this$0.colorize("&aPremium account automatically registered! Logging you in..."));
                                    this.this$1.this$0.autoLoginPlayer(player);
                                }
                            }.runTask((Plugin)this.this$0);
                        } else {
                            new BukkitRunnable(this){
                                final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    this.this$1.this$0.legacyPlayers.add(playerId);
                                    player.sendMessage(this.this$1.this$0.colorize("&cAuto-registration failed. Please use &b/register <password>&c."));
                                    this.this$1.this$0.requiredAuthType.put(playerId, "register");
                                    this.this$1.this$0.teleportToAuthWorld(player, "register");
                                    this.this$1.this$0.showAuthEffects(player, "register");
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                }
                catch (Exception e) {
                    this.this$0.getLogger().log(Level.SEVERE, "Auto-register premium failed", e);
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void showBossBar(Player player, String message) {
        if (!this.config.getBoolean("effects.bossbar.enabled", true)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        BossBar bar = this.playerBossBars.get(playerId);
        if (bar == null) {
            BarStyle style;
            BarColor color;
            try {
                color = BarColor.valueOf((String)this.config.getString("effects.bossbar.color", "BLUE").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                color = BarColor.BLUE;
            }
            try {
                style = BarStyle.valueOf((String)this.config.getString("effects.bossbar.style", "SOLID").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                style = BarStyle.SOLID;
            }
            bar = Bukkit.createBossBar((String)this.colorize(message), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
            bar.addPlayer(player);
            this.playerBossBars.put(playerId, bar);
        } else {
            bar.setTitle(this.colorize(message));
        }
        bar.setVisible(true);
    }

    private void hideBossBar(Player player) {
        UUID playerId = player.getUniqueId();
        BossBar bar = this.playerBossBars.remove(playerId);
        if (bar != null) {
            bar.removeAll();
        }
    }

    private void sendTitle(Player player, String title, String subtitle) {
        if (!this.config.getBoolean("effects.title.enabled", true)) {
            return;
        }
        player.sendTitle(this.colorize(title), this.colorize(subtitle), this.config.getInt("effects.title.fade-in", 10), this.config.getInt("effects.title.stay", 40), this.config.getInt("effects.title.fade-out", 10));
    }

    private void applyBlindness(Player player) {
        if (!this.config.getBoolean("effects.blindness.enabled", true)) {
            return;
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, this.config.getInt("effects.blindness.duration-seconds", 2) * 20, this.config.getInt("effects.blindness.amplifier", 1) - 1, false, false, false));
    }

    private void showAuthEffects(final Player player, String action) {
        String bossMsg = this.config.getString("effects.bossbar.message-" + action, "&bPlease " + action + " using /" + action + " <password>");
        this.showBossBar(player, bossMsg);
        String titlePath = "effects.title." + action + "-required.title";
        String subPath = "effects.title." + action + "-required.subtitle";
        this.sendTitle(player, this.config.getString(titlePath, "&" + (action.equals("login") ? "cLogin" : "6Registration") + " Required"), this.config.getString(subPath, "&7Use /" + action + " <password>"));
        this.applyBlindness(player);
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || this.this$0.isLoggedIn(player.getUniqueId())) {
                    this.cancel();
                    return;
                }
                this.this$0.applyBlindness(player);
            }
        }.runTaskTimer((Plugin)this, (long)this.config.getInt("effects.blindness.duration-seconds", 2) * 20L, (long)this.config.getInt("effects.blindness.duration-seconds", 2) * 20L);
    }

    private void teleportToAuthWorld(Player player, String action) {
        String worldName = this.config.getString("auth-world." + action + "-world");
        if (worldName != null && !worldName.trim().isEmpty()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                World authWorld = this.getWorldSafe(worldName);
                if (authWorld != null) {
                    double x = this.config.getDouble("auth-world." + action + "-x", authWorld.getSpawnLocation().getX());
                    double y = this.config.getDouble("auth-world." + action + "-y", authWorld.getSpawnLocation().getY());
                    double z = this.config.getDouble("auth-world." + action + "-z", authWorld.getSpawnLocation().getZ());
                    float yaw = (float)this.config.getDouble("auth-world." + action + "-yaw", (double)authWorld.getSpawnLocation().getYaw());
                    float pitch = (float)this.config.getDouble("auth-world." + action + "-pitch", (double)authWorld.getSpawnLocation().getPitch());
                    Location authLocation = new Location(authWorld, x, y, z, yaw, pitch);
                    Location currentLoc = player.getLocation();
                    if (!currentLoc.getWorld().getName().equals(authWorld.getName()) || currentLoc.distance(authLocation) > 2.0) {
                        this.pendingTeleports.put(player.getUniqueId(), true);
                        boolean success = player.teleport(authLocation);
                        if (success) {
                            if ("login".equals(action)) {
                                player.sendMessage(this.colorize("&aPlease login with &b/login <password>&a to continue."));
                            } else if ("register".equals(action)) {
                                player.sendMessage(this.colorize("&aPlease register with &b/register <password>&a to continue."));
                            }
                            this.getLogger().info("Teleported " + player.getName() + " to " + action + " world: " + worldName);
                        } else {
                            player.sendMessage(this.colorize("&cFailed to teleport to authentication area."));
                            this.getLogger().warning("Failed to teleport " + player.getName() + " to auth world: " + worldName);
                        }
                        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.pendingTeleports.remove(player.getUniqueId()), 40L);
                    }
                } else {
                    this.getLogger().warning("Auth world '" + worldName + "' not found or could not be loaded for action: " + action);
                    player.sendMessage(this.colorize("&cAuthentication area is not available. Please contact an administrator."));
                }
            }, 10L);
        } else {
            this.getLogger().info("No auth world configured for " + action + ", player remains in current world");
        }
    }

    private void teleportBackFromAuth(Player player) {
        UUID playerId = player.getUniqueId();
        Location originalLocation = this.originalJoinLocations.get(playerId);
        if (originalLocation != null) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                World originalWorld = originalLocation.getWorld();
                if (originalWorld == null || Bukkit.getWorld((UUID)originalWorld.getUID()) == null) {
                    World mainWorld = (World)Bukkit.getWorlds().get(0);
                    this.pendingTeleports.put(playerId, true);
                    player.teleport(mainWorld.getSpawnLocation());
                    player.sendMessage(this.colorize("&aWelcome! You have been teleported to spawn."));
                    this.getLogger().info("Teleported " + player.getName() + " to spawn - original world unavailable");
                } else {
                    Location currentLoc = player.getLocation();
                    if (!currentLoc.getWorld().getName().equals(originalWorld.getName()) || currentLoc.distance(originalLocation) > 5.0) {
                        this.pendingTeleports.put(playerId, true);
                        boolean success = player.teleport(originalLocation);
                        if (success) {
                            player.sendMessage(this.colorize("&aWelcome! You have been returned to your original location."));
                            this.getLogger().info("Successfully teleported " + player.getName() + " back to original location in world: " + originalWorld.getName());
                        } else {
                            World mainWorld = (World)Bukkit.getWorlds().get(0);
                            player.teleport(mainWorld.getSpawnLocation());
                            player.sendMessage(this.colorize("&aWelcome! You have been teleported to spawn."));
                            this.getLogger().warning("Failed to return " + player.getName() + " to original location, sent to spawn instead");
                        }
                    } else {
                        player.sendMessage(this.colorize("&aWelcome!"));
                        this.getLogger().info("Player " + player.getName() + " is already at original location, skipping teleport");
                    }
                }
                this.originalJoinLocations.remove(playerId);
                Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.pendingTeleports.remove(playerId), 40L);
            }, 5L);
        } else {
            this.getLogger().info("No original location stored for " + player.getName() + ", keeping player at current location");
        }
    }

    private World getWorldSafe(String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            try {
                this.getLogger().info("Attempting to load world: " + worldName);
                world = Bukkit.createWorld((WorldCreator)new WorldCreator(worldName));
                if (world != null) {
                    this.getLogger().info("Successfully loaded world: " + worldName);
                } else {
                    this.getLogger().warning("Failed to create/load world: " + worldName);
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to load world: " + worldName + " - " + e.getMessage());
                return null;
            }
        }
        return world;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.colorize(this.config.getString("messages.not-player")));
            return true;
        }
        if (!this.pluginEnabled) {
            sender.sendMessage(this.colorize("&cAdvanceAuth is disabled - No valid license!"));
            return true;
        }
        Player player = (Player)sender;
        String cmd = command.getName().toLowerCase();
        if (!this.isLoggedIn(player.getUniqueId()) && !this.isAuthCommand(cmd)) {
            player.sendMessage(this.colorize(this.config.getString("messages.not-logged-in")));
            return true;
        }
        switch (cmd) {
            case "register": {
                if (args.length < 1) {
                    player.sendMessage(this.colorize(this.config.getString("messages.register-usage")));
                    return true;
                }
                if (this.isLoggedIn(player.getUniqueId())) {
                    player.sendMessage(this.colorize(this.config.getString("messages.already-logged-in")));
                    return true;
                }
                this.registerPlayer(player, args[0]);
                return true;
            }
            case "login": {
                if (args.length < 1) {
                    player.sendMessage(this.colorize(this.config.getString("messages.login-usage")));
                    return true;
                }
                if (this.isLoggedIn(player.getUniqueId())) {
                    player.sendMessage(this.colorize(this.config.getString("messages.already-logged-in")));
                    return true;
                }
                this.loginPlayer(player, args[0], args.length > 1 ? args[1] : null);
                return true;
            }
            case "logout": {
                if (!this.isLoggedIn(player.getUniqueId())) {
                    player.sendMessage(this.colorize(this.config.getString("messages.not-logged-in")));
                    return true;
                }
                this.logoutPlayer(player);
                return true;
            }
            case "auth": {
                return this.handleAuthCommand(player, args);
            }
            case "setemail": {
                return this.handleSetEmailCommand(player, args);
            }
            case "resetpassword": {
                return this.handleResetPasswordCommand(player, args);
            }
            case "verifyotp": {
                return this.handleVerifyOTPCommand(player, args);
            }
            case "sessions": {
                return this.handleSessionsCommand(player, args);
            }
        }
        return false;
    }

    private boolean handleAuthCommand(Player player, String[] args) {
        if (args.length == 0) {
            player.sendMessage(this.colorize("&b&lAdvanceAuth Commands:"));
            player.sendMessage(this.colorize("&7/register <password> &f- Register a new account"));
            player.sendMessage(this.colorize("&7/login <password> [--session] &f- Login to your account"));
            player.sendMessage(this.colorize("&7/logout &f- Logout from your account"));
            player.sendMessage(this.colorize("&7/setemail <email> &f- Set your email address"));
            player.sendMessage(this.colorize("&7/resetpassword &f- Reset password via email"));
            player.sendMessage(this.colorize("&7/verifyotp <otp> <newpassword> &f- Verify OTP & set new password"));
            player.sendMessage(this.colorize("&7/sessions &f- View your active sessions"));
            if (player.hasPermission("authplugin.admin")) {
                player.sendMessage(this.colorize("&6&lAdmin Commands:"));
                player.sendMessage(this.colorize("&7/auth reload &f- Reload configuration"));
                player.sendMessage(this.colorize("&7/auth setLoginLocation &f- Set login teleport location"));
                player.sendMessage(this.colorize("&7/auth setRegisterLocation &f- Set register teleport location"));
                player.sendMessage(this.colorize("&7/auth clearLoginLocation &f- Clear login location"));
                player.sendMessage(this.colorize("&7/auth clearRegisterLocation &f- Clear register location"));
                player.sendMessage(this.colorize("&7/auth viewLocations &f- View auth locations"));
                player.sendMessage(this.colorize("&7/auth forceregister <player> &f- Force register a legacy player"));
                player.sendMessage(this.colorize("&7/auth resetlegacy <player> &f- Reset player account and mark as legacy"));
                player.sendMessage(this.colorize("&7/auth localregister <player> <password> &f- Emergency local registration"));
                player.sendMessage(this.colorize("&7/auth stats &f- View server statistics"));
                player.sendMessage(this.colorize("&7/auth ipinfo <player> &f- View player's IP information"));
                player.sendMessage(this.colorize("&7/auth sessioninfo <player> &f- View player's session information"));
            }
            return true;
        }
        if (!player.hasPermission("authplugin.admin")) {
            player.sendMessage(this.colorize(this.config.getString("messages.no-permission")));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.reloadConfig();
                this.config = this.getConfig();
                this.validatePlugin();
                player.sendMessage(this.colorize(this.config.getString("messages.reload-success")));
                return true;
            }
            case "setloginlocation": {
                this.setAuthLocation(player, "login");
                return true;
            }
            case "setregisterlocation": {
                this.setAuthLocation(player, "register");
                return true;
            }
            case "clearloginlocation": {
                this.clearAuthLocation("login");
                player.sendMessage(this.colorize("&aLogin location cleared. Players will remain in current world."));
                return true;
            }
            case "clearregisterlocation": {
                this.clearAuthLocation("register");
                player.sendMessage(this.colorize("&aRegister location cleared. Players will remain in current world."));
                return true;
            }
            case "viewlocations": {
                this.viewAuthLocations(player);
                return true;
            }
            case "forceregister": {
                if (args.length < 2) {
                    player.sendMessage(this.colorize("&cUsage: /auth forceregister <player>"));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target != null) {
                    this.legacyPlayers.add(target.getUniqueId());
                    player.sendMessage(this.colorize("&aMarked " + target.getName() + " as a legacy player. They can now register."));
                    target.sendMessage(this.colorize("&aYou can now register with &b/register <password>&a."));
                } else {
                    player.sendMessage(this.colorize("&cPlayer not found or not online."));
                }
                return true;
            }
            case "resetlegacy": {
                if (args.length < 2) {
                    player.sendMessage(this.colorize("&cUsage: /auth resetlegacy <player>"));
                    return true;
                }
                this.resetPlayerAccount(player, args[1]);
                return true;
            }
            case "localregister": {
                if (args.length < 3) {
                    player.sendMessage(this.colorize("&cUsage: /auth localregister <player> <password>"));
                    return true;
                }
                this.emergencyLocalRegister(player, args[1], args[2]);
                return true;
            }
            case "stats": {
                this.showServerStats(player);
                return true;
            }
            case "ipinfo": {
                if (args.length < 2) {
                    player.sendMessage(this.colorize("&cUsage: /auth ipinfo <player>"));
                    return true;
                }
                this.showIPInfo(player, args[1]);
                return true;
            }
            case "sessioninfo": {
                if (args.length < 2) {
                    player.sendMessage(this.colorize("&cUsage: /auth sessioninfo <player>"));
                    return true;
                }
                this.showSessionInfo(player, args[1]);
                return true;
            }
        }
        player.sendMessage(this.colorize("&cUnknown auth command. Use /auth for help."));
        return true;
    }

    private boolean handleSetEmailCommand(Player player, String[] args) {
        if (args.length < 1) {
            player.sendMessage(this.colorize("&cUsage: /setemail <email>"));
            return true;
        }
        String email = args[0];
        if (!this.isValidEmail(email)) {
            player.sendMessage(this.colorize("&cInvalid email format. Please use a valid email address."));
            return true;
        }
        if (!this.isLoggedIn(player.getUniqueId())) {
            player.sendMessage(this.colorize("&cYou must be logged in to set your email."));
            return true;
        }
        this.setPlayerEmail(player, email);
        return true;
    }

    private boolean handleResetPasswordCommand(Player player, String[] args) {
        this.resetPassword(player);
        return true;
    }

    private boolean handleVerifyOTPCommand(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.colorize("&cUsage: /verifyotp <otp> <newpassword>"));
            return true;
        }
        String otp = args[0];
        String newPassword = args[1];
        this.verifyOTP(player, otp, newPassword);
        return true;
    }

    private boolean handleSessionsCommand(Player player, String[] args) {
        if (!this.isLoggedIn(player.getUniqueId())) {
            player.sendMessage(this.colorize("&cYou must be logged in to view sessions."));
            return true;
        }
        this.showPlayerSessions(player);
        return true;
    }

    private void registerPlayer(final Player player, final String password) {
        final UUID playerId = player.getUniqueId();
        if (this.processingPlayers.contains(playerId)) {
            player.sendMessage(this.colorize("&cPlease wait, your request is being processed..."));
            return;
        }
        this.processingPlayers.add(playerId);
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                block13: {
                    try {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("username", player.getName());
                        data.put("password", password);
                        data.put("serverKey", this.this$0.serverKey);
                        data.put("ip", this.this$0.getPlayerIP(player));
                        data.put("isLegacy", this.this$0.legacyPlayers.contains(playerId));
                        data.put("overwriteExisting", this.this$0.legacyPlayers.contains(playerId));
                        RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                        Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/register").post(body).build();
                        try (Response response = this.this$0.httpClient.newCall(request).execute();){
                            String responseBody;
                            String string = responseBody = response.body() != null ? response.body().string() : "";
                            if (response.isSuccessful()) {
                                new BukkitRunnable(this){
                                    final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void run() {
                                        this.this$1.this$0.processingPlayers.remove(playerId);
                                        this.this$1.this$0.legacyPlayers.remove(playerId);
                                        player.sendMessage(this.this$1.this$0.colorize(this.this$1.this$0.config.getString("messages.register-success")));
                                        player.sendMessage(this.this$1.this$0.colorize("&aNow please use &b/login " + password + "&a to login!"));
                                        this.this$1.this$0.requiredAuthType.put(playerId, "login");
                                        this.this$1.this$0.teleportToAuthWorld(player, "login");
                                        this.this$1.this$0.showAuthEffects(player, "login");
                                    }
                                }.runTask((Plugin)this.this$0);
                                break block13;
                            }
                            Object error = "Registration failed";
                            String code = "";
                            try {
                                Map<String, Object> errorResponse = this.this$0.objectMapper.readValue(responseBody, new TypeReference<Map<String, Object>>(){});
                                if (errorResponse.containsKey("error")) {
                                    error = errorResponse.get("error").toString();
                                }
                                if (errorResponse.containsKey("code") && "USER_EXISTS".equals(code = errorResponse.get("code").toString())) {
                                    error = this.this$0.legacyPlayers.contains(playerId) ? "Account already exists. Since you're a legacy player, please use /login with your existing password, or ask an admin to reset your account with /auth resetlegacy " + player.getName() : "User already exists, please use /login instead";
                                }
                            }
                            catch (IOException errorResponse) {
                                // empty catch block
                            }
                            final String finalError = error;
                            new BukkitRunnable(this){
                                final /* synthetic */ 5 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    this.this$1.this$0.processingPlayers.remove(playerId);
                                    player.sendMessage(this.this$1.this$0.colorize(this.this$1.this$0.config.getString("messages.register-error").replace("%error%", finalError)));
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                    catch (Exception e) {
                        this.this$0.getLogger().log(Level.SEVERE, "Registration API call failed", e);
                        new BukkitRunnable(this){
                            final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                this.this$1.this$0.processingPlayers.remove(playerId);
                                player.sendMessage(this.this$1.this$0.colorize(this.this$1.this$0.config.getString("messages.api-error")));
                            }
                        }.runTask((Plugin)this.this$0);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void loginPlayer(final Player player, final String password, final String sessionFlag) {
        int maxAttempts;
        final UUID playerId = player.getUniqueId();
        if (this.processingPlayers.contains(playerId)) {
            player.sendMessage(this.colorize("&cPlease wait, your request is being processed..."));
            return;
        }
        final int attempts = this.loginAttempts.getOrDefault(playerId, 0);
        if (attempts >= (maxAttempts = this.config.getInt("login.max-attempts", 3))) {
            player.kickPlayer(this.colorize(this.config.getString("messages.login-timeout")));
            return;
        }
        this.processingPlayers.add(playerId);
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                block17: {
                    try {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("username", player.getName());
                        data.put("password", password);
                        data.put("serverKey", this.this$0.serverKey);
                        data.put("ip", this.this$0.getPlayerIP(player));
                        data.put("sessionDuration", sessionFlag != null && sessionFlag.equalsIgnoreCase("--session") ? 24 : 1);
                        RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                        Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/login").post(body).build();
                        try (final Response response = this.this$0.httpClient.newCall(request).execute();){
                            String responseBody;
                            String string = responseBody = response.body() != null ? response.body().string() : "";
                            if (response.isSuccessful()) {
                                Map<String, Object> responseData = this.this$0.objectMapper.readValue(responseBody, new TypeReference<Map<String, Object>>(){});
                                String sessionToken = (String)responseData.get("sessionToken");
                                long sessionDuration = sessionFlag != null && sessionFlag.equalsIgnoreCase("--session") ? 86400000L : 3600000L;
                                this.this$0.loginAttempts.remove(playerId);
                                long sessionExpiry = System.currentTimeMillis() + sessionDuration;
                                PlayerAuthData authData = new PlayerAuthData(playerId, sessionExpiry);
                                this.this$0.playerData.put(playerId, authData);
                                if (sessionToken != null) {
                                    this.this$0.playerSessions.put(playerId, sessionToken);
                                }
                                new BukkitRunnable(this){
                                    final /* synthetic */ 6 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void run() {
                                        this.this$1.this$0.processingPlayers.remove(playerId);
                                        this.this$1.this$0.legacyPlayers.remove(playerId);
                                        player.sendMessage(this.this$1.this$0.colorize(this.this$1.this$0.config.getString("messages.login-success")));
                                        if (sessionFlag != null && sessionFlag.equalsIgnoreCase("--session")) {
                                            player.sendMessage(this.this$1.this$0.colorize("&aSession created! You will stay logged in for 24 hours."));
                                        }
                                        this.this$1.this$0.teleportBackFromAuth(player);
                                        String joinMessage = this.this$1.this$0.config.getString("messages.custom-join-message", "&a%player% joined the server!").replace("%player%", player.getName());
                                        Bukkit.broadcastMessage((String)this.this$1.this$0.colorize(joinMessage));
                                        List commands = this.this$1.this$0.config.getStringList("on-login");
                                        if (commands != null && !commands.isEmpty()) {
                                            for (String cmd : commands) {
                                                String formattedCmd = cmd.replace("%player%", player.getName());
                                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)formattedCmd);
                                            }
                                        }
                                        this.this$1.this$0.requiredAuthType.remove(playerId);
                                        this.this$1.this$0.hideBossBar(player);
                                        player.removePotionEffect(PotionEffectType.BLINDNESS);
                                    }
                                }.runTask((Plugin)this.this$0);
                                break block17;
                            }
                            String error = "Invalid credentials";
                            String code = "";
                            try {
                                Map<String, Object> errorResponse = this.this$0.objectMapper.readValue(responseBody, new TypeReference<Map<String, Object>>(){});
                                if (errorResponse.containsKey("error")) {
                                    error = errorResponse.get("error").toString();
                                }
                                if (errorResponse.containsKey("code")) {
                                    code = errorResponse.get("code").toString();
                                }
                                if (errorResponse.containsKey("banned") && ((Boolean)errorResponse.get("banned")).booleanValue()) {
                                    final String banMessage = error;
                                    new BukkitRunnable(this){
                                        final /* synthetic */ 6 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        public void run() {
                                            this.this$1.this$0.processingPlayers.remove(playerId);
                                            player.kickPlayer(this.this$1.this$0.colorize(banMessage));
                                        }
                                    }.runTask((Plugin)this.this$0);
                                    return;
                                }
                            }
                            catch (IOException errorResponse) {
                                // empty catch block
                            }
                            if (response.code() == 401) {
                                this.this$0.loginAttempts.put(playerId, attempts + 1);
                            }
                            final String finalError = error;
                            final String finalCode = code;
                            final int remainingAttempts = maxAttempts - (attempts + 1);
                            new BukkitRunnable(this){
                                final /* synthetic */ 6 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    this.this$1.this$0.processingPlayers.remove(playerId);
                                    if ("USER_NOT_FOUND".equals(finalCode)) {
                                        this.this$1.this$0.legacyPlayers.add(playerId);
                                        player.sendMessage(this.this$1.this$0.colorize("&cUser not found! Please use &b/register <password>&c to create an account."));
                                        player.sendMessage(this.this$1.this$0.colorize("&7(You joined before the authentication plugin was added)"));
                                        String currentAuthType = this.this$1.this$0.requiredAuthType.get(playerId);
                                        if (!"register".equals(currentAuthType)) {
                                            this.this$1.this$0.requiredAuthType.put(playerId, "register");
                                            this.this$1.this$0.teleportToAuthWorld(player, "register");
                                            this.this$1.this$0.showAuthEffects(player, "register");
                                        }
                                    } else {
                                        player.sendMessage(this.this$1.this$0.colorize(this.this$1.this$0.config.getString("messages.login-error").replace("%error%", finalError)));
                                        if (remainingAttempts > 0 && response.code() == 401) {
                                            player.sendMessage(this.this$1.this$0.colorize(this.this$1.this$0.config.getString("messages.login-attempts").replace("%attempts%", String.valueOf(remainingAttempts))));
                                        }
                                    }
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                    catch (Exception e) {
                        this.this$0.getLogger().log(Level.SEVERE, "Login API call failed", e);
                        new BukkitRunnable(this){
                            final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                this.this$1.this$0.processingPlayers.remove(playerId);
                                player.sendMessage(this.this$1.this$0.colorize(this.this$1.this$0.config.getString("messages.api-error")));
                            }
                        }.runTask((Plugin)this.this$0);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void logoutPlayer(Player player) {
        UUID playerId = player.getUniqueId();
        String sessionToken = this.playerSessions.get(playerId);
        if (sessionToken != null) {
            this.invalidateSession(player, sessionToken);
        }
        this.playerData.remove(playerId);
        this.processingPlayers.remove(playerId);
        this.requiredAuthType.remove(playerId);
        this.playerSessions.remove(playerId);
        this.playerEmails.remove(playerId);
        this.otpRequests.remove(playerId);
        this.otpEmails.remove(playerId);
        this.otpExpiry.remove(playerId);
        this.hideBossBar(player);
        player.removePotionEffect(PotionEffectType.BLINDNESS);
        String leaveMessage = this.config.getString("messages.custom-leave-message", "&c%player% left the server!").replace("%player%", player.getName());
        Bukkit.broadcastMessage((String)this.colorize(leaveMessage));
        player.sendMessage(this.colorize(this.config.getString("messages.logout-success")));
    }

    private void invalidateSession(Player player, final String sessionToken) {
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("sessionToken", sessionToken);
                    data.put("serverKey", this.this$0.serverKey);
                    RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                    Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/logout").post(body).build();
                    this.this$0.httpClient.newCall(request).execute();
                }
                catch (Exception e) {
                    this.this$0.getLogger().log(Level.WARNING, "Failed to invalidate session on backend", e);
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void validateSession(final Player player, final String sessionToken) {
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("sessionToken", sessionToken);
                    data.put("serverKey", this.this$0.serverKey);
                    RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                    Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/validateSession").post(body).build();
                    try (Response response = this.this$0.httpClient.newCall(request).execute();){
                        if (response.isSuccessful() && response.body() != null) {
                            Map<String, Object> result = this.this$0.objectMapper.readValue(response.body().string(), new TypeReference<Map<String, Object>>(){});
                            final boolean valid = (Boolean)result.get("valid");
                            new BukkitRunnable(this){
                                final /* synthetic */ 8 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    if (valid) {
                                        long sessionDuration = this.this$1.this$0.config.getLong("login.session-duration", 86400L) * 1000L;
                                        PlayerAuthData authData = new PlayerAuthData(player.getUniqueId(), System.currentTimeMillis() + sessionDuration);
                                        this.this$1.this$0.playerData.put(player.getUniqueId(), authData);
                                        player.sendMessage(this.this$1.this$0.colorize("&aSession restored! Welcome back, " + player.getName() + "!"));
                                        this.this$1.this$0.teleportBackFromAuth(player);
                                        this.this$1.this$0.requiredAuthType.remove(player.getUniqueId());
                                        this.this$1.this$0.legacyPlayers.remove(player.getUniqueId());
                                    } else {
                                        this.this$1.this$0.playerSessions.remove(player.getUniqueId());
                                        this.this$1.this$0.handlePlayerJoin(player);
                                    }
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                }
                catch (Exception e) {
                    this.this$0.getLogger().log(Level.WARNING, "Failed to validate session", e);
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void setPlayerEmail(final Player player, final String email) {
        final UUID playerId = player.getUniqueId();
        if (this.processingPlayers.contains(playerId)) {
            player.sendMessage(this.colorize("&cPlease wait, your request is being processed..."));
            return;
        }
        this.processingPlayers.add(playerId);
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                block12: {
                    try {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("username", player.getName());
                        data.put("email", email);
                        data.put("serverKey", this.this$0.serverKey);
                        RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                        Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/setmail").post(body).build();
                        try (Response response = this.this$0.httpClient.newCall(request).execute();){
                            String responseBody;
                            String string = responseBody = response.body() != null ? response.body().string() : "";
                            if (response.isSuccessful()) {
                                this.this$0.playerEmails.put(playerId, email);
                                new BukkitRunnable(this){
                                    final /* synthetic */ 9 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void run() {
                                        this.this$1.this$0.processingPlayers.remove(playerId);
                                        player.sendMessage(this.this$1.this$0.colorize("&aEmail set successfully!"));
                                        player.sendMessage(this.this$1.this$0.colorize("&7You can now use /resetpassword if you forget your password."));
                                    }
                                }.runTask((Plugin)this.this$0);
                                break block12;
                            }
                            String error = "Failed to set email";
                            try {
                                Map<String, Object> errorResponse = this.this$0.objectMapper.readValue(responseBody, new TypeReference<Map<String, Object>>(){});
                                if (errorResponse.containsKey("error")) {
                                    error = errorResponse.get("error").toString();
                                }
                            }
                            catch (IOException errorResponse) {
                                // empty catch block
                            }
                            final String finalError = error;
                            new BukkitRunnable(this){
                                final /* synthetic */ 9 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    this.this$1.this$0.processingPlayers.remove(playerId);
                                    player.sendMessage(this.this$1.this$0.colorize("&cFailed to set email: " + finalError));
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                    catch (Exception e) {
                        this.this$0.getLogger().log(Level.SEVERE, "Set email API call failed", e);
                        new BukkitRunnable(this){
                            final /* synthetic */ 9 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                this.this$1.this$0.processingPlayers.remove(playerId);
                                player.sendMessage(this.this$1.this$0.colorize("&cAPI error occurred while setting email."));
                            }
                        }.runTask((Plugin)this.this$0);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void resetPassword(final Player player) {
        final UUID playerId = player.getUniqueId();
        if (this.processingPlayers.contains(playerId)) {
            player.sendMessage(this.colorize("&cPlease wait, your request is being processed..."));
            return;
        }
        this.processingPlayers.add(playerId);
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                block14: {
                    try {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("username", player.getName());
                        data.put("serverKey", this.this$0.serverKey);
                        RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                        Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/resetPasswordByUsername").post(body).build();
                        try (Response response = this.this$0.httpClient.newCall(request).execute();){
                            String responseBody;
                            String string = responseBody = response.body() != null ? response.body().string() : "";
                            if (response.isSuccessful()) {
                                Map<String, Object> responseData = this.this$0.objectMapper.readValue(responseBody, new TypeReference<Map<String, Object>>(){});
                                boolean success = (Boolean)responseData.get("success");
                                if (success) {
                                    final String maskedEmail = (String)responseData.get("email");
                                    final String message = (String)responseData.get("message");
                                    final String localOTP = this.this$0.generateLocalOTP();
                                    this.this$0.otpRequests.put(playerId, localOTP);
                                    this.this$0.otpExpiry.put(playerId, System.currentTimeMillis() + 600000L);
                                    this.this$0.otpEmails.put(playerId, player.getName());
                                    new BukkitRunnable(this){
                                        final /* synthetic */ 10 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        public void run() {
                                            this.this$1.this$0.processingPlayers.remove(playerId);
                                            player.sendMessage(this.this$1.this$0.colorize("&a\u2713 " + message));
                                            player.sendMessage(this.this$1.this$0.colorize("&7Sent to: &f" + maskedEmail));
                                            player.sendMessage(this.this$1.this$0.colorize("&7Please check your email for the OTP code."));
                                            player.sendMessage(this.this$1.this$0.colorize("&7Use &b/verifyotp <otp> <newpassword> &7to reset your password."));
                                            player.sendMessage(this.this$1.this$0.colorize("&e\u26a0 OTP expires in 10 minutes."));
                                            this.this$1.this$0.getLogger().info("Password reset OTP requested for " + player.getName() + " (Email: " + maskedEmail + ")");
                                            this.this$1.this$0.getLogger().info("Local OTP for " + player.getName() + ": " + localOTP + " (for testing)");
                                        }
                                    }.runTask((Plugin)this.this$0);
                                } else {
                                    String error = (String)responseData.get("error");
                                    final String finalError = error != null ? error : "Unknown error";
                                    new BukkitRunnable(this){
                                        final /* synthetic */ 10 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        public void run() {
                                            this.this$1.this$0.processingPlayers.remove(playerId);
                                            if (finalError.contains("No email set")) {
                                                player.sendMessage(this.this$1.this$0.colorize("&c\u2717 No email is set for your account."));
                                                player.sendMessage(this.this$1.this$0.colorize("&7Please set your email first with &b/setemail <email>&7."));
                                            } else if (finalError.contains("User not found")) {
                                                player.sendMessage(this.this$1.this$0.colorize("&c\u2717 User not found. Please register first with /register."));
                                            } else {
                                                player.sendMessage(this.this$1.this$0.colorize("&c\u2717 Password reset failed: " + finalError));
                                            }
                                        }
                                    }.runTask((Plugin)this.this$0);
                                }
                                break block14;
                            }
                            String error = "Failed to request password reset";
                            try {
                                Map<String, Object> errorResponse = this.this$0.objectMapper.readValue(responseBody, new TypeReference<Map<String, Object>>(){});
                                if (errorResponse.containsKey("error")) {
                                    error = errorResponse.get("error").toString();
                                }
                            }
                            catch (IOException errorResponse) {
                                // empty catch block
                            }
                            final String finalError = error;
                            new BukkitRunnable(this){
                                final /* synthetic */ 10 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    this.this$1.this$0.processingPlayers.remove(playerId);
                                    player.sendMessage(this.this$1.this$0.colorize("&c\u2717 Could not verify your account. Please try again."));
                                    this.this$1.this$0.getLogger().warning("Password reset API error for " + player.getName() + ": " + finalError);
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                    catch (Exception e) {
                        this.this$0.getLogger().log(Level.SEVERE, "Password reset API call failed for " + player.getName(), e);
                        new BukkitRunnable(this){
                            final /* synthetic */ 10 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                this.this$1.this$0.processingPlayers.remove(playerId);
                                player.sendMessage(this.this$1.this$0.colorize("&c\u2717 Could not connect to authentication server. Please try again later."));
                            }
                        }.runTask((Plugin)this.this$0);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private String generateLocalOTP() {
        Random random = new Random();
        return String.format("%06d", random.nextInt(999999));
    }

    private void verifyOTP(Player player, String otp, String newPassword) {
        UUID playerId = player.getUniqueId();
        if (this.processingPlayers.contains(playerId)) {
            player.sendMessage(this.colorize("&cPlease wait, your request is being processed..."));
            return;
        }
        Long expiryTime = this.otpExpiry.get(playerId);
        if (expiryTime == null || System.currentTimeMillis() > expiryTime) {
            player.sendMessage(this.colorize("&c\u2717 OTP has expired. Please request a new one with /resetpassword."));
            this.otpEmails.remove(playerId);
            this.otpExpiry.remove(playerId);
            this.otpRequests.remove(playerId);
            return;
        }
        String storedOTP = this.otpRequests.get(playerId);
        if (storedOTP != null && storedOTP.equals(otp)) {
            this.processOTPVerification(player, playerId, otp, newPassword);
            return;
        }
        this.processOTPVerification(player, playerId, otp, newPassword);
    }

    private void processOTPVerification(final Player player, final UUID playerId, final String otp, final String newPassword) {
        this.processingPlayers.add(playerId);
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                block12: {
                    try {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("username", player.getName());
                        data.put("serverKey", this.this$0.serverKey);
                        data.put("otp", otp);
                        data.put("newPassword", newPassword);
                        RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                        Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/verifyOTPByUsername").post(body).build();
                        try (Response response = this.this$0.httpClient.newCall(request).execute();){
                            String responseBody;
                            String string = responseBody = response.body() != null ? response.body().string() : "";
                            if (response.isSuccessful()) {
                                final Map<String, Object> responseData = this.this$0.objectMapper.readValue(responseBody, new TypeReference<Map<String, Object>>(){});
                                final boolean success = (Boolean)responseData.get("success");
                                new BukkitRunnable(this){
                                    final /* synthetic */ 11 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void run() {
                                        this.this$1.this$0.processingPlayers.remove(playerId);
                                        this.this$1.this$0.otpEmails.remove(playerId);
                                        this.this$1.this$0.otpExpiry.remove(playerId);
                                        this.this$1.this$0.otpRequests.remove(playerId);
                                        if (success) {
                                            player.sendMessage(this.this$1.this$0.colorize("&a\u2713 Password changed successfully!"));
                                            player.sendMessage(this.this$1.this$0.colorize("&7You can now login with your new password."));
                                            if (this.this$1.this$0.isLoggedIn(playerId)) {
                                                this.this$1.this$0.logoutPlayer(player);
                                                player.sendMessage(this.this$1.this$0.colorize("&e\u26a0 You have been logged out for security. Please login with your new password."));
                                            }
                                            player.sendMessage(this.this$1.this$0.colorize("&7Use &b/login " + newPassword + " &7to login."));
                                        } else {
                                            String error = (String)responseData.get("error");
                                            player.sendMessage(this.this$1.this$0.colorize("&c\u2717 OTP verification failed: " + (error != null ? error : "Unknown error")));
                                        }
                                    }
                                }.runTask((Plugin)this.this$0);
                                break block12;
                            }
                            String error = "Failed to verify OTP";
                            try {
                                Map<String, Object> errorResponse = this.this$0.objectMapper.readValue(responseBody, new TypeReference<Map<String, Object>>(){});
                                if (errorResponse.containsKey("error")) {
                                    error = errorResponse.get("error").toString();
                                }
                            }
                            catch (IOException errorResponse) {
                                // empty catch block
                            }
                            final String finalError = error;
                            new BukkitRunnable(this){
                                final /* synthetic */ 11 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    this.this$1.this$0.processingPlayers.remove(playerId);
                                    player.sendMessage(this.this$1.this$0.colorize("&c\u2717 OTP verification failed: " + finalError));
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                    catch (Exception e) {
                        this.this$0.getLogger().log(Level.SEVERE, "OTP verification API call failed for " + player.getName(), e);
                        new BukkitRunnable(this){
                            final /* synthetic */ 11 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                this.this$1.this$0.processingPlayers.remove(playerId);
                                player.sendMessage(this.this$1.this$0.colorize("&c\u2717 Could not connect to authentication server. Please try again."));
                            }
                        }.runTask((Plugin)this.this$0);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void showPlayerSessions(final Player player) {
        UUID playerId = player.getUniqueId();
        final String sessionToken = this.playerSessions.get(playerId);
        if (sessionToken == null) {
            player.sendMessage(this.colorize("&cNo active sessions found."));
            return;
        }
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("sessionToken", sessionToken);
                    data.put("serverKey", this.this$0.serverKey);
                    RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                    Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/validateSession").post(body).build();
                    try (Response response = this.this$0.httpClient.newCall(request).execute();){
                        if (response.isSuccessful() && response.body() != null) {
                            final Map<String, Object> result = this.this$0.objectMapper.readValue(response.body().string(), new TypeReference<Map<String, Object>>(){});
                            final boolean valid = (Boolean)result.get("valid");
                            new BukkitRunnable(this){
                                final /* synthetic */ 12 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    player.sendMessage(this.this$1.this$0.colorize("&6&lYour Session Info:"));
                                    player.sendMessage(this.this$1.this$0.colorize("&7Status: " + (valid ? "&aActive" : "&cExpired")));
                                    if (valid) {
                                        player.sendMessage(this.this$1.this$0.colorize("&7Session Token: &f" + sessionToken.substring(0, 16) + "..."));
                                        player.sendMessage(this.this$1.this$0.colorize("&7Expires in: &f" + String.valueOf(result.get("timeRemaining")) + " hours"));
                                        player.sendMessage(this.this$1.this$0.colorize("&7Last Activity: &f" + String.valueOf(result.get("lastActivity"))));
                                        player.sendMessage(this.this$1.this$0.colorize("&7IP Address: &f" + String.valueOf(result.get("ipAddress"))));
                                    }
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                }
                catch (Exception e) {
                    this.this$0.getLogger().log(Level.WARNING, "Failed to get session info", e);
                    new BukkitRunnable(this){
                        final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            player.sendMessage(this.this$1.this$0.colorize("&cFailed to retrieve session information."));
                        }
                    }.runTask((Plugin)this.this$0);
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void showServerStats(final Player admin) {
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/stats?serverKey=" + this.this$0.serverKey).get().build();
                    try (Response response = this.this$0.httpClient.newCall(request).execute();){
                        if (response.isSuccessful() && response.body() != null) {
                            final Map<String, Object> result = this.this$0.objectMapper.readValue(response.body().string(), new TypeReference<Map<String, Object>>(){});
                            new BukkitRunnable(this){
                                final /* synthetic */ 13 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    admin.sendMessage(this.this$1.this$0.colorize("&6&lServer Statistics:"));
                                    admin.sendMessage(this.this$1.this$0.colorize("&7Total Users: &f" + String.valueOf(result.get("totalUsers"))));
                                    admin.sendMessage(this.this$1.this$0.colorize("&7Active Today: &f" + String.valueOf(result.get("loggedInToday"))));
                                    admin.sendMessage(this.this$1.this$0.colorize("&7New Registrations (30d): &f" + String.valueOf(result.get("registrationsLast30Days"))));
                                    admin.sendMessage(this.this$1.this$0.colorize("&7Banned Users: &f" + String.valueOf(result.get("bannedUsers"))));
                                    admin.sendMessage(this.this$1.this$0.colorize("&7Active Users: &f" + String.valueOf(result.get("activeUsers"))));
                                }
                            }.runTask((Plugin)this.this$0);
                        }
                    }
                }
                catch (Exception e) {
                    this.this$0.getLogger().log(Level.WARNING, "Failed to get server stats", e);
                    new BukkitRunnable(this){
                        final /* synthetic */ 13 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            admin.sendMessage(this.this$1.this$0.colorize("&cFailed to retrieve server statistics."));
                        }
                    }.runTask((Plugin)this.this$0);
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private void showIPInfo(Player admin, String targetName) {
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            admin.sendMessage(this.colorize("&cPlayer not found or not online."));
            return;
        }
        String ip = this.getPlayerIP(target);
        admin.sendMessage(this.colorize("&6&lIP Information for " + target.getName() + ":"));
        admin.sendMessage(this.colorize("&7Current IP: &f" + ip));
        admin.sendMessage(this.colorize("&7Players with same IP:"));
        Set playersWithSameIP = this.ipToPlayers.getOrDefault(ip, new HashSet());
        for (UUID playerId : playersWithSameIP) {
            Player p = Bukkit.getPlayer((UUID)playerId);
            if (p == null) continue;
            admin.sendMessage(this.colorize("&7- &f" + p.getName() + " &7(" + (this.isLoggedIn(playerId) ? "&aOnline" : "&cOffline") + "&7)"));
        }
    }

    private void showSessionInfo(Player admin, String targetName) {
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            admin.sendMessage(this.colorize("&cPlayer not found or not online."));
            return;
        }
        UUID targetId = target.getUniqueId();
        String sessionToken = this.playerSessions.get(targetId);
        PlayerAuthData authData = this.playerData.get(targetId);
        admin.sendMessage(this.colorize("&6&lSession Information for " + target.getName() + ":"));
        admin.sendMessage(this.colorize("&7Logged In: " + (this.isLoggedIn(targetId) ? "&aYes" : "&cNo")));
        if (authData != null) {
            long timeRemaining = (authData.getExpiryTime() - System.currentTimeMillis()) / 1000L / 60L;
            admin.sendMessage(this.colorize("&7Session Expires in: &f" + timeRemaining + " minutes"));
        }
        if (sessionToken != null) {
            admin.sendMessage(this.colorize("&7Session Token: &f" + sessionToken.substring(0, 16) + "..."));
        } else {
            admin.sendMessage(this.colorize("&7Session Token: &cNot set"));
        }
        admin.sendMessage(this.colorize("&7Email: &f" + this.playerEmails.getOrDefault(targetId, "Not set")));
    }

    private void setAuthLocation(Player player, String type) {
        Location loc = player.getLocation();
        String worldName = loc.getWorld().getName();
        this.config.set("auth-world." + type + "-world", (Object)worldName);
        this.config.set("auth-world." + type + "-x", (Object)loc.getX());
        this.config.set("auth-world." + type + "-y", (Object)loc.getY());
        this.config.set("auth-world." + type + "-z", (Object)loc.getZ());
        this.config.set("auth-world." + type + "-yaw", (Object)Float.valueOf(loc.getYaw()));
        this.config.set("auth-world." + type + "-pitch", (Object)Float.valueOf(loc.getPitch()));
        this.saveConfig();
        player.sendMessage(this.colorize("&a" + type.substring(0, 1).toUpperCase() + type.substring(1) + " location set to your current position in world: " + worldName));
        this.getLogger().info("Set " + type + " location to: " + worldName + " " + loc.getX() + "," + loc.getY() + "," + loc.getZ());
    }

    private void clearAuthLocation(String type) {
        this.config.set("auth-world." + type + "-world", (Object)"");
        this.config.set("auth-world." + type + "-x", (Object)0);
        this.config.set("auth-world." + type + "-y", (Object)0);
        this.config.set("auth-world." + type + "-z", (Object)0);
        this.config.set("auth-world." + type + "-yaw", (Object)0);
        this.config.set("auth-world." + type + "-pitch", (Object)0);
        this.saveConfig();
    }

    private void viewAuthLocations(Player player) {
        double z;
        double y;
        double x;
        String loginWorld = this.config.getString("auth-world.login-world", "");
        String registerWorld = this.config.getString("auth-world.register-world", "");
        player.sendMessage(this.colorize("&6&lAuth Locations:"));
        if (loginWorld.isEmpty()) {
            player.sendMessage(this.colorize("&7Login Location: &cNot set"));
        } else {
            x = this.config.getDouble("auth-world.login-x", 0.0);
            y = this.config.getDouble("auth-world.login-y", 0.0);
            z = this.config.getDouble("auth-world.login-z", 0.0);
            player.sendMessage(this.colorize("&7Login Location: &a" + loginWorld + " &f(" + Math.round(x) + ", " + Math.round(y) + ", " + Math.round(z) + ")"));
        }
        if (registerWorld.isEmpty()) {
            player.sendMessage(this.colorize("&7Register Location: &cNot set"));
        } else {
            x = this.config.getDouble("auth-world.register-x", 0.0);
            y = this.config.getDouble("auth-world.register-y", 0.0);
            z = this.config.getDouble("auth-world.register-z", 0.0);
            player.sendMessage(this.colorize("&7Register Location: &a" + registerWorld + " &f(" + Math.round(x) + ", " + Math.round(y) + ", " + Math.round(z) + ")"));
        }
    }

    private void emergencyLocalRegister(Player admin, String targetName, String password) {
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            admin.sendMessage(this.colorize("&cPlayer not found or not online."));
            return;
        }
        long sessionDuration = this.config.getLong("login.session-duration", 86400L) * 1000L;
        PlayerAuthData authData = new PlayerAuthData(target.getUniqueId(), System.currentTimeMillis() + sessionDuration);
        this.playerData.put(target.getUniqueId(), authData);
        this.legacyPlayers.remove(target.getUniqueId());
        admin.sendMessage(this.colorize("&aEmergency local registration for " + targetName + " successful!"));
        target.sendMessage(this.colorize("&aYou have been registered locally by an admin. You can now play."));
        this.teleportBackFromAuth(target);
        this.hideBossBar(target);
        target.removePotionEffect(PotionEffectType.BLINDNESS);
    }

    private void resetPlayerAccount(final Player admin, final String targetName) {
        new BukkitRunnable(this){
            final /* synthetic */ AdvanceLogin this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("username", targetName);
                    data.put("serverKey", this.this$0.serverKey);
                    data.put("adminAction", true);
                    RequestBody body = RequestBody.create(MediaType.parse("application/json"), this.this$0.objectMapper.writeValueAsString(data));
                    Request request = new Request.Builder().url("https://plugins.zenuxs.in/api/resetUser").post(body).build();
                    try (Response response = this.this$0.httpClient.newCall(request).execute();){
                        final boolean success = response.isSuccessful();
                        final String responseMessage = response.body() != null ? response.body().string() : "";
                        new BukkitRunnable(this){
                            final /* synthetic */ 14 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                if (success) {
                                    admin.sendMessage(this.this$1.this$0.colorize("&aSuccessfully reset account for " + targetName + ". They can now register as a legacy player."));
                                    Player target = Bukkit.getPlayer((String)targetName);
                                    if (target != null) {
                                        this.this$1.this$0.legacyPlayers.add(target.getUniqueId());
                                        this.this$1.this$0.playerData.remove(target.getUniqueId());
                                        this.this$1.this$0.playerSessions.remove(target.getUniqueId());
                                        this.this$1.this$0.playerEmails.remove(target.getUniqueId());
                                        target.sendMessage(this.this$1.this$0.colorize("&aYour account has been reset by an admin. You can now register with &b/register <password>&a."));
                                        this.this$1.this$0.hideBossBar(target);
                                        target.removePotionEffect(PotionEffectType.BLINDNESS);
                                    }
                                } else {
                                    admin.sendMessage(this.this$1.this$0.colorize("&cFailed to reset account for " + targetName + ". Error: " + responseMessage));
                                }
                            }
                        }.runTask((Plugin)this.this$0);
                    }
                }
                catch (Exception e) {
                    this.this$0.getLogger().log(Level.SEVERE, "Reset user API call failed", e);
                    new BukkitRunnable(this){
                        final /* synthetic */ 14 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            admin.sendMessage(this.this$1.this$0.colorize("&cAPI error occurred while resetting account."));
                        }
                    }.runTask((Plugin)this.this$0);
                }
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private boolean isValidEmail(String email) {
        return email.matches("^[A-Za-z0-9+_.-]+@(.+)$");
    }

    private void cleanupOTPs() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, Long>> iterator = this.otpExpiry.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Long> entry = iterator.next();
            if (entry.getValue() >= now) continue;
            UUID playerId = entry.getKey();
            iterator.remove();
            this.otpEmails.remove(playerId);
            this.otpRequests.remove(playerId);
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null) continue;
            player.sendMessage(this.colorize("&c\u2717 Your OTP has expired. Please request a new one."));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (player.isOnline() && !this.originalJoinLocations.containsKey(playerId)) {
                this.originalJoinLocations.put(playerId, player.getLocation().clone());
                this.getLogger().info("Stored original join location for " + player.getName() + " on join: " + player.getLocation().getWorld().getName() + " " + player.getLocation().getBlockX() + "," + player.getLocation().getBlockY() + "," + player.getLocation().getBlockZ());
            }
        }, 5L);
        event.setJoinMessage(null);
        if (!this.pluginEnabled) {
            return;
        }
        if (!this.checkIPLimit(player)) {
            player.kickPlayer(this.colorize(this.config.getString("messages.ip-limit-exceeded", "&cToo many players from your IP address!")));
            return;
        }
        this.playerData.put(playerId, new PlayerAuthData(playerId, 0L));
        this.handlePlayerJoin(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        event.setQuitMessage(null);
        if (this.isLoggedIn(playerId)) {
            String leaveMessage = this.config.getString("messages.custom-leave-message", "&c%player% left the server!").replace("%player%", player.getName());
            Bukkit.broadcastMessage((String)this.colorize(leaveMessage));
        }
        this.playerData.remove(playerId);
        this.loginAttempts.remove(playerId);
        this.originalJoinLocations.remove(playerId);
        this.requiredAuthType.remove(playerId);
        this.processingPlayers.remove(playerId);
        this.legacyPlayers.remove(playerId);
        this.pendingTeleports.remove(playerId);
        this.otpRequests.remove(playerId);
        this.otpEmails.remove(playerId);
        this.otpExpiry.remove(playerId);
        this.hideBossBar(player);
        player.removePotionEffect(PotionEffectType.BLINDNESS);
        String ip = this.getPlayerIP(player);
        Set<UUID> playersWithIP = this.ipToPlayers.get(ip);
        if (playersWithIP != null) {
            playersWithIP.remove(playerId);
            if (playersWithIP.isEmpty()) {
                this.ipToPlayers.remove(ip);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (!this.pluginEnabled) {
            return;
        }
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase().substring(1);
        String[] parts = command.split(" ");
        String cmd = parts[0];
        if (!this.isLoggedIn(player.getUniqueId())) {
            if (this.isBungeeCommand(cmd, parts)) {
                event.setCancelled(true);
                player.sendMessage(this.colorize(this.config.getString("messages.not-logged-in")));
                return;
            }
            if (!this.isAuthCommand(cmd)) {
                event.setCancelled(true);
                player.sendMessage(this.colorize(this.config.getString("messages.not-logged-in")));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onServerCommand(ServerCommandEvent event) {
        String command = event.getCommand().toLowerCase();
        if (command.startsWith("server") || command.startsWith("bungee") || command.startsWith("connect") || command.startsWith("glist") || command.startsWith("send") || command.startsWith("ip")) {
            this.getLogger().warning("Blocked potential BungeeCord command from console: " + command);
            event.setCancelled(true);
        }
    }

    private boolean isBungeeCommand(String cmd, String[] parts) {
        return cmd.equals("server") || cmd.equals("lobby") || cmd.equals("hub") || cmd.equals("bungee") || cmd.equals("bungeecord") || cmd.equals("connect") || parts.length > 1 && (parts[0].equals("server") || parts[0].equals("connect"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.pluginEnabled || !this.config.getBoolean("protection.prevent-movement", true)) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.pendingTeleports.containsKey(playerId)) {
            return;
        }
        if (!(this.isLoggedIn(playerId) || event.getFrom().getX() == event.getTo().getX() && event.getFrom().getZ() == event.getTo().getZ())) {
            event.setTo(event.getFrom());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.pluginEnabled || !this.config.getBoolean("protection.prevent-block-break", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.isLoggedIn(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.pluginEnabled || !this.config.getBoolean("protection.prevent-block-place", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.isLoggedIn(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.pluginEnabled || !this.config.getBoolean("protection.prevent-interaction", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.isLoggedIn(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.pluginEnabled || !this.config.getBoolean("protection.prevent-chat", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.isLoggedIn(player.getUniqueId())) {
            event.setCancelled(true);
            player.sendMessage(this.colorize(this.config.getString("messages.not-logged-in")));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        if (!this.pluginEnabled || !this.config.getBoolean("protection.prevent-damage", true)) {
            return;
        }
        if (event.getEntity() instanceof Player && !this.isLoggedIn((player = (Player)event.getEntity()).getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (!this.pluginEnabled || !this.config.getBoolean("protection.prevent-item-drop", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.isLoggedIn(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (!this.pluginEnabled || !this.config.getBoolean("protection.prevent-item-pickup", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.isLoggedIn(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        if (!this.pluginEnabled || !this.config.getBoolean("protection.prevent-interaction", true)) {
            return;
        }
        if (event.getWhoClicked() instanceof Player && !this.isLoggedIn((player = (Player)event.getWhoClicked()).getUniqueId())) {
            event.setCancelled(true);
        }
    }

    private boolean isLoggedIn(UUID playerId) {
        PlayerAuthData data = this.playerData.get(playerId);
        return data != null && data.isValid();
    }

    private boolean isAuthCommand(String cmd) {
        return cmd.equals("register") || cmd.equals("login") || cmd.equals("logout") || cmd.equals("auth") || cmd.equals("setemail") || cmd.equals("resetpassword") || cmd.equals("verifyotp") || cmd.equals("sessions");
    }

    private boolean checkIPLimit(Player player) {
        if (!this.config.getBoolean("ip-limit.enabled", false)) {
            return true;
        }
        String ip = this.getPlayerIP(player);
        int maxPlayersPerIP = this.config.getInt("ip-limit.max-players", 3);
        Set playersWithIP = this.ipToPlayers.computeIfAbsent(ip, k -> new HashSet());
        if (playersWithIP.size() >= maxPlayersPerIP && !playersWithIP.contains(player.getUniqueId())) {
            return false;
        }
        playersWithIP.add(player.getUniqueId());
        return true;
    }

    private String getPlayerIP(Player player) {
        try {
            InetSocketAddress address = player.getAddress();
            return address != null ? address.getAddress().getHostAddress() : "unknown";
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private void cleanupSessions() {
        long now = System.currentTimeMillis();
        this.playerData.entrySet().removeIf(entry -> !((PlayerAuthData)entry.getValue()).isValid(now));
        this.originalJoinLocations.entrySet().removeIf(entry -> Bukkit.getPlayer((UUID)((UUID)entry.getKey())) == null);
        this.requiredAuthType.entrySet().removeIf(entry -> Bukkit.getPlayer((UUID)((UUID)entry.getKey())) == null);
        this.pendingTeleports.entrySet().removeIf(entry -> Bukkit.getPlayer((UUID)((UUID)entry.getKey())) == null);
    }

    private String colorize(String message) {
        return message == null ? "" : ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String cmd;
        ArrayList<String> completions = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return completions;
        }
        Player player = (Player)sender;
        switch (cmd = command.getName().toLowerCase()) {
            case "auth": {
                if (args.length == 1) {
                    List<String> suggestions = Arrays.asList("reload", "setLoginLocation", "setRegisterLocation", "clearLoginLocation", "clearRegisterLocation", "viewLocations", "forceregister", "resetlegacy", "localregister", "stats", "ipinfo", "sessioninfo");
                    for (String suggestion : suggestions) {
                        if (!suggestion.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                        completions.add(suggestion);
                    }
                } else {
                    if (args.length != 2 || !args[0].equalsIgnoreCase("forceregister") && !args[0].equalsIgnoreCase("resetlegacy") && !args[0].equalsIgnoreCase("localregister") && !args[0].equalsIgnoreCase("ipinfo") && !args[0].equalsIgnoreCase("sessioninfo")) break;
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (!p.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        completions.add(p.getName());
                    }
                }
                break;
            }
            case "login": {
                if (args.length != 1 || !player.hasPermission("authplugin.admin")) break;
                completions.add("<password>");
                completions.add("--session");
                break;
            }
            case "register": {
                if (args.length != 1) break;
                completions.add("<password>");
                break;
            }
            case "setemail": {
                if (args.length != 1) break;
                completions.add("<email>");
                break;
            }
            case "resetpassword": {
                break;
            }
            case "verifyotp": {
                if (args.length == 1) {
                    completions.add("<otp>");
                    break;
                }
                if (args.length != 2) break;
                completions.add("<new-password>");
            }
        }
        return completions;
    }

    public void onDisable() {
        if (this.httpClient != null) {
            this.httpClient.dispatcher().executorService().shutdown();
            this.httpClient.connectionPool().evictAll();
        }
        this.playerBossBars.values().forEach(BossBar::removeAll);
        this.playerBossBars.clear();
        this.getLogger().info("AdvanceAuth disabled");
    }

    private static class PlayerAuthData {
        private final UUID playerId;
        private final long expiryTime;

        public PlayerAuthData(UUID playerId, long expiryTime) {
            this.playerId = playerId;
            this.expiryTime = expiryTime;
        }

        public boolean isValid() {
            return this.isValid(System.currentTimeMillis());
        }

        public boolean isValid(long currentTime) {
            return this.expiryTime > currentTime;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public long getExpiryTime() {
            return this.expiryTime;
        }
    }
}

